<?php

/**
 * Dragonbyte-Tech.com Downloads Mod 1.0.0
 * 
 * @author David Tobin
 * @copyright 2010
 * @version 1.0
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

$download = Downloads::load_module('download');

$fileid = $vbulletin->input->clean_gpc('g', 'fileid', TYPE_INT);

if (empty($fileid)) {
	Downloads::throw_error('dbtech_downloads_invalid_id');
}

if ($vbulletin->userinfo['dbtech_downloads_comment_notifs']) {
	$notifs = unserialize($vbulletin->userinfo['dbtech_downloads_comment_notifs']);
	
	if (count($notifs) > 0 && in_array($fileid, (array)array_keys($notifs))) {
		unset($notifs[$fileid]);
		
		$newnotifs = serialize($notifs);
		
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "user
			SET
				dbtech_downloads_comment_notifs = '" . $db->escape_string($newnotifs) . "'
				
			WHERE userid = {$vbulletin->userinfo['userid']}	
		");
	}
}

$downloads = vB_Template::create('dbtech_downloads_download');

($hook = vBulletinHook::fetch_hook('dbtech_downloads_download_start')) ? eval($hook) : false;

$cats = $vbulletin->dbtech_downloads_categories;

$files = $db->query_read("
	SELECT f.*, g.*, g.private AS private, g.password AS password, g.moderation AS moderation, u.userid, u.username, g.image AS imageid FROM " . TABLE_PREFIX . "dbtech_downloads_filegroup AS g
	LEFT JOIN " . TABLE_PREFIX . "dbtech_downloads_fileinfo AS f ON (f.parentid = g.groupid)
	LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid = g.userid)
	WHERE g.groupid = $fileid
");

require_once (DIR . '/includes/class_bbcode.php');

if (!function_exists('convert_url_to_bbcode'))
{
	require_once(DIR . '/includes/functions_newpost.php');
}


$bbcode = new vB_BbCodeParser($vbulletin, fetch_tag_list());

$bbimgcodeval = $vbulletin->options['allowbbimagecode'];

$vbulletin->options['allowbbimagecode'] = true;


if ($db->num_rows($files) == 0) {
	Downloads::throw_error('dbtech_downloads_bad_file');
} else {
	$filebits 				= '';
	$gallerybits			= intval($vbulletin->versionnumber) == 4 ? '<div class="tr">' : '<tr>';
	$screens				= 0;
	$morebits 			= '';
	$report_reasons 	= '';
	$downloadcount 	= 0;
	$passconfirm 		= false;
	$i						= 0;
	$x						= 0;
	$imagelist			= array();
	
	while ($file = $db->fetch_array($files)) {
		$catid = $file['categoryid'];
		foreach ((array)$cats[$catid] AS $key => $cat) {
			if ($key == 'password') {
				$file['penabled'] = $cats[$catid][$key];	
			} else if ($key == 'private') {
				$file['canpriv'] = $cats[$catid][$key];
			} else if ($key == 'moderation') {
				$file['canmoderation'] = $cats[$catid][$key];
			} else {
				$file[$key] = $cats[$catid][$key];
			}
			
		}
		
		$mirrors = $file['mirrors'];
		
		$permissions 	= unserialize($file['permissions']);
		$secondary		= explode(',', $vbulletin->userinfo['membergroupids']);
		
		$canview = false;
		foreach ($secondary AS $ugid) {
			if (in_array($ugid, (array)$permissions['view'])) {
				$canview = true;
			}
		}
		
		
		$groupid = $file['groupid'];
		
		if ($file['userid'] == $vbulletin->userinfo['userid'] || Downloads::is_mod() == true) {
			$show['screenshot'] = 1;
		}
		
		if (!empty($permissions) && (in_array($vbulletin->userinfo['usergroupid'], $permissions['view']) || $canview == true)) {
			if (($file['userid'] == $vbulletin->userinfo['userid'] || Downloads::is_mod() == true) && $vbulletin->userinfo['userid']) {
				$show['edit_file'] 		= 1;
				$show['delete_file']	= 1;
			}
			
			if ($file['canmoderation'] == 1 && $file['moderation'] == 1 && Downloads::is_mod() == false) {
				Downloads::throw_error('dbtech_downloads_file_being_reviewed');
				exit;
			}
			
			if ($file['canpriv'] && !empty($file['private']) && $file['userid'] != $vbulletin->userinfo['userid'] && Downloads::is_mod() == false) {
				$allowedusers = unserialize($file['private']);
				
				if (!in_array($vbulletin->userinfo['userid'], (array)$allowedusers)) {
					Downloads::throw_error('dbtech_downloads_private_file_error');
				}
			}
			
			if ($i == 0) {
				if ($file['parentid'] > 0) {
					$navbits[$vbulletin->options['dbtech_downloads_link'] . '.php?do=listings&catid=' . $file['parentid']] = $vbulletin->dbtech_downloads_categories[$file['parentid']]['catname'];	
				}

				$navbits[$vbulletin->options['dbtech_downloads_link'] . '.php?do=listings&catid=' . $file['categoryid']] = $file['catname'];
				$navbits[] = $file['groupname'];
				
				$i++;
			}

			if ($file['penabled'] == 1 && Downloads::is_mod() == false && $file['userid'] != $vbulletin->userinfo['userid'] && ($file['password'] != '' || $passconfirm == false)) {
				$passhash = $vbulletin->input->clean_gpc('c', $vbulletin->config['Misc']['cookieprefix'] . '_downloadpass_' . $file['groupid'], TYPE_STR);

				if ($passhash != $file['password']) {
					header('Location: ' . $vbulletin->options['bburl'] . '/' . $vbulletin->options['dbtech_downloads_link'] . '.php?do=password&fileid=' . $file['groupid']);
					exit;
				} else {
					$passconfirm = true;
				}
			}
			
			if ($file['image'] == 1) {
				array_push($imagelist, $file['fileid']);
			}
			
			$filetemp 	= vB_Template::create('dbtech_downloads_download_files');
			$gallery		= vB_Template::create('dbtech_downloads_download_screenshot');
			
			$file['catname'] = $cats[$file['catid']]['catname'];
			
			$downloadcount = $file['downloads'];
			
			
			if ($vbulletin->options['allowedbbcodes'] & 64)	{
				$file['groupdesc'] = convert_url_to_bbcode($file['groupdesc']);
			}
			
			$file['rating']			= Downloads::beautify_rating($file['rating']);
			$file['filesize'] 		= Downloads::convert_filesize($file['filesize']);
			$file['groupdesc']		= $bbcode->parse(Downloads::convert_wysiwyg_html_to_bbcode(nl2br($file['groupdesc'])), 'nonforum', true, true, '', 3, false, 'on_nl2br');
			
			if ($file['screenshot'] == 0) {
				$filetemp->register('file', $file);
				
				if (!empty($file['filename'])) {
					$filebits .= $filetemp->render();
				}
				
				$fileinfo = $file;
			} else {
				$x++;
				
				$gallery->register('file', $file);
				
				if ($x > 5) {
					$gallerybits .= intval($vbulletin->versionnumber) == 4 ? '</div><div class="tr">' : '</tr><tr>';

					$x = 0;
				}
				
				if (!empty($file['filename'])) {
					$gallerybits .= $gallery->render();
					
					$screens++;
				}
				
				$fileinfo = $file;
			}
		} else {
			print_no_permission();
		}
	}
	
	$fileinfo['downloads'] = $downloadcount;
	
	$reasons = explode('<br />', nl2br($vbulletin->options['dbtech_downloads_report_file_reasons']));
	
	$report_reasons = '';
	foreach ($reasons AS $reasonid => $reason) {
		$reasonid++;
		$report_reasons .= '<option value="' . $reasonid . '">' . $reason . '</option>' . "\n";
	}
	
	$commentreasons = explode('<br />', nl2br($vbulletin->options['dbtech_downloads_report_comment_reasons']));
		
	$comment_reasons = '';
	foreach ($commentreasons AS $creasonid => $creason) {
		$creasonid++;
		$comment_reasons .= '<option value="' . $creasonid . '">' . $creason . '</option>' . "\n";
	}
	
	$denycats = array();
	
	foreach ($vbulletin->dbtech_downloads_categories AS $catid => $category) {
		$permissions    = unserialize($category['permissions']);
		$secondary      = explode(',', $vbulletin->userinfo['membergroupids']);
		$canview        = false;
	
		foreach ($secondary AS $usergroupid) {
			if (in_array($secondary, (array)$permissions['view'])) {
				$canview = true;
			}
		}
		
		if ($canview == false && !in_array($vbulletin->userinfo['usergroupid'], (array)$permissions['view'])) {
			$denycats[] = $category['catid'];
		}
	}
	
	$morequery = $db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_filegroup
		WHERE userid = " . $fileinfo['userid'] . " AND groupid != " . $fileinfo['groupid'] . " AND categoryid NOT IN ('" . implode(',', $denycats) . "')
		ORDER BY RAND()
		LIMIT 10
	");
	
	while ($more = $db->fetch_array($morequery)) {
		$moretemp = vB_Template::create('dbtech_downloads_download_more');
		$more['fileid'] = $more['groupid'];
		
		$moretemp->register('file', $more);
		
		$morebits .= $moretemp->render();
	}
	
	$fileinfo['updated'] = vbdate($vbulletin->options['dateformat'], intval($fileinfo['updated']), true, false);
	$fileinfo['dateline'] = vbdate($vbulletin->options['dateformat'], intval($fileinfo['dateline']), true, false);
	
	if (!empty($vbulletin->userinfo['dbtech_downloads_favourites']) && count(unserialize($vbulletin->userinfo['dbtech_downloads_favourites'])) > 0) {
		$favourites = unserialize($vbulletin->userinfo['dbtech_downloads_favourites']);
	} else {
		$favourites = array();
	}
	
	if (in_array($fileinfo['groupid'], $favourites)) {
		$styleinfo_add = 'style="display: none;"';
		$styleinfo_remove = '';
	} else {
		$styleinfo_remove = 'style="display: none;"';
		$styleinfo_add = '';
	}
	
	$getcomments = $db->query_read("
		SELECT c.*, u.username, u.userid FROM " . TABLE_PREFIX . "dbtech_downloads_comments AS c
		LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid = c.userid)
		WHERE c.fileid = " . $fileid . "
		ORDER BY c.dateline DESC
	");
	
	$comments = '';
	while ($comment = $db->fetch_array($getcomments)) {
		$comms = vB_Template::create('dbtech_downloads_download_comments');
		
		$comment['dateline'] = vbdate('M jS Y', $comment['dateline'], true, false);
		
		$display['commentdelete'] = Downloads::is_mod() == true || $comment['userid'] == $vbulletin->userinfo['userid'] ? true : false;
		
		$comms->register('display', $display);
		$comms->register('comment', $comment);
		
		$comments .= $comms->render();
	}
	
	if (!empty($mirrors)) {
		$mirrors = unserialize($mirrors);
		
		$mirroroutput 	= '';
		$i				= 1;
		foreach ((array)$mirrors AS $u => $mirror) {
			
			$mtemp = vB_Template::create('dbtech_downloads_download_mirrors');
			
			$mtemp->register('i', $i);
			$mtemp->register('mirror', $mirror);
			
			$i++;
			
			$mirroroutput .= $mtemp->render();
		}
		
		$mirrors = $mirroroutput;
	}
	
	$gallerybits .= intval($vbulletin->versionnumber) == 4 ? '</div>' : '</tr>';
	
	if ($screens == 0) {
		$gallerybits = '';
	}
	
	$screencount = $db->query_first("
		SELECT COUNT(fileid) AS screens FROM " . TABLE_PREFIX . "dbtech_downloads_fileinfo
		WHERE screenshot = '1' AND parentid = " . intval($groupid) . "
	");
	
	$totalfiles 		= $screencount['screens'];
	$allowedfiles 	= $vbulletin->options['dbtech_downloads_max_screenshots'] - $totalfiles;
	$screenhtml	= intval($vbulletin->versionnumber) == 4 ? '<div class="tr">' : '<tr>';
	$x					= 0;
	
	if ($allowedfiles > 0) {
		for ($i=0;$i<$allowedfiles;$i++) {
			$x++;
			
			if ($x == 4) {
				$x = 0;
				
				$screenhtml .= intval($vbulletin->versionnumber) == 4 ? '</div><div class="tr">' : '</tr><tr>';
			}
			
			$screenhtml .= intval($vbulletin->versionnumber) == 4 ? '<div class="td">' : '<td>';
			$screenhtml .= intval($vbulletin->versionnumber) == 4 ? '<input type="file" class="textbox" name="screenshots[]" />' : '<input type="file" style="color: red; font-weight: bold;" name="screenshots[]" />';
			$screenhtml .= intval($vbulletin->versionnumber) == 4 ? '</div>' : '</tr>';
		}
	
		$screenhtml .= intval($vbulletin->versionnumber) == 4 ? '</div>' : '</tr>';	
	} else {
		$screenhtml = $vbphrase['dbtech_downlads_max_screenshots_exceeded'];	
	}
	
	$vbulletin->options['allowbbimagecode'] = $bbimgcodeval;
	
	($hook = vBulletinHook::fetch_hook('dbtech_downloads_download_complete')) ? eval($hook) : false;
	
	$downloads->register('file', $fileinfo);
	$downloads->register('report_reasons', $report_reasons);
	$downloads->register('mirrors', $mirrors);
	$downloads->register('imagelist', $imagelist);
	$downloads->register('comment_reasons', $comment_reasons);
	$downloads->register('styleinfo_add', $styleinfo_add);
	$downloads->register('styleinfo_remove', $styleinfo_remove);
	$downloads->register('comments', $comments);
	$downloads->register('filebits', $filebits);
	$downloads->register('gallerybits', $gallerybits);
	$downloads->register('screenhtml', $screenhtml);
	$downloads->register('thumbhash', $thumbhash);
	$downloads->register('morebits', $morebits);
	$downloads->register('show', $show);
	$downloads->register('groupid', $groupid);
	$downloads->register('template_hook', $template_hook);
}

$JAVASCRIPT_INCLUDE .= 'Downloads.init_downloads_page(' . $vbulletin->userinfo['userid'] . ', ' . $fileinfo['groupid'] . ');';

$HTML .= $downloads->render();

?>